#include <Core/Core.h>
#include <SSH/SSH.h>

using namespace Upp;

// SshAsyncRequests.cpp:
// Demonstates asynchronous calls and polymorphism with SSH package.
// Uses SFtp and Exec subsystems.

// A popular public test server:
// -----------------------------
// Host:     test.rebex.net
// User:     user
// Password: password
// Command:  ls -l
// Path:     /pub/example/
// File:     readme.txt


CONSOLE_APP_MAIN
{
	const char *filename    = "readme.txt";
	const char *cmd         = "ls -l .";

	Ssh session;
	Cout() << "Connecting to Rebex public sftp test server...\n";
	if(session.Connect("test.rebex.net", 22, "demo", "password")) {
		Array<Ssh::Subsystem> channels;
		auto& sftp = channels.Add(new SFtp(session)).To<SFtp>();
		auto& exec = channels.Add(new Exec(session)).To<Exec>();
		FileOut local_file(filename);
		if(!local_file.IsOpen()) Exit(1);
		sftp.StartGet(local_file, filename, SFtp::READ, 0755);
		exec.StartExecute(cmd, Cout(), Cerr());
		{
			while(!channels.IsEmpty()) {
				auto i = 0;
				SocketWaitEvent we;
				we.Add(session.GetSocket());
				while (i < channels.GetCount()) {
					auto& ch = channels[i];
					we.Wait(10);
					ch.Do();
					if(!ch.InProgress()) {
						if(ch.IsSuccess()) {
							if(ch.Is<SFtp>())
								Cout() << Format("File '%s' is successfully downloaded.\n", filename);
							else
							if(ch.Is<Exec>())
								Cout() << Format("Remote command processed. Return code is %d.\n",
													ch.To<Exec>().GetExitCode());
						}
						else Cerr() << ch.GetErrorDesc() << "\n";
						channels.Remove(i);
						break;
					}
					i++;
				}
			}
		}
	}
	else Cerr() << session.GetErrorDesc() << "\n";
}
